alter proc [dbo].[CDSEditGetInfo] @Date1 smalldatetime,
                                  @Date2 smalldatetime,
                                  @ID    numeric(15,0),
                                  @Mode  tinyint
as
SET NOCOUNT ON

if @Mode=0
begin
    select DealID     = D.DealID,
           DealDate   = D.DealDate,
           DealNumber = ltrim(rtrim(D.Number)),
           FOBrief    = rtrim(FO.Brief),
           DealQty    = D.Qty,
           Fund       = rtrim(C.Brief),
           ClName     = rtrim(I.Brief)
    from tDeal D
    join tInstitution I on I.InstitutionID=D.InstitutionID
    join tInstrument FO on FO.InstrumentID=D.InstrumentID
    join tCurrency C on C.CurrencyID=D.FundID
    where D.ValueDate>=@Date1
      and D.DealDate<=@Date2
      and D.Flag % 100 < 10
      and (D.InstrumentID=@ID or @ID=0 and D.InstrumentID in(select InstrumentID from tInstrument where TableName='TCDeal_T'))
    order by D.DealDate,I.Brief,D.Qty 

    return 0
end


declare @ResourceID numeric(15,0),
        @Account    char(20),
        @Val        char(3),
        @DateStart  smalldatetime,
        @Rest       money,
        @AccCount   integer,
        @Prc        float,
        @LastDate   smalldatetime,
        @Payment    money


create table #Warr(WarrID numeric(15,0),ResourceID numeric(15,0),Rest money,ConsID numeric(15,0),NumCons int)
create table #Cons(ConsID numeric(15,0),NumCons int)

insert #Warr
select D.DealID,AL.ResourceID,0,D.InstitutionID,1+row_number() over (order by D.DealDate,D.DealID)
from tWarrantyHistory DR
join tDeal D on D.DealID=DR.ChildID and D.DealDate<=@Date2 and D.ValueDate>=@Date2
join tInstrument FO on FO.InstrumentID=D.InstrumentID and FO.Brief in('')
join tWarAccountLink AL on AL.ObjectID=D.DealID and AL.OnDate<=@Date2 and (AL.DateLast>@Date2 or AL.DateLast='19000101')
join tTypeAccLink TA on AL.RuleID=TA.TypeAccLinkID and TA.Brief=''
where DR.ParentID=@ID
  and DR.RelType=55
  and DR.OnDate<=@Date2
  and DR.DateLast>@Date2

insert #Cons
select ConsID,NumCons from #Warr
union all
select InstitutionID,1 from tDeal where DealID=@ID

select @AccCount=count(*) from #Warr
select @AccCount=isnull(@AccCount,0)+1

select @ResourceID=R.ResourceID,@Account=R.Brief,@Val=C.Brief,@DateStart=R.DateStart
from tLoanAccountLink AL
join tTypeAccLink TA on AL.RuleID=TA.TypeAccLinkID and TA.Brief=''
join tResource R on R.ResourceID=AL.ResourceID
join tCurrency C on C.CurrencyID=R.FundID
where AL.DealID=@ID
    and AL.OnDate<=@Date2
    and (AL.DateLast>@Date2 or AL.DateLast='19000101')

delete pResource where SPID=@@spid
delete pResList where SPID=@@spid

insert pResource(SPID,ResourceID) select @@spid,ResourceID from #Warr
if @ResourceID is not null insert pResource(SPID,ResourceID) values(@@spid,@ResourceID)

exec AccList_Rest @Date2

select @Rest=Rest from pResList where SPID=@@spid and ResourceID=@ResourceID

update #Warr set Rest=PL.Rest from pResList PL where PL.SPID=@@spid and PL.ResourceID=#Warr.ResourceID

delete pResource where SPID=@@spid
delete pResList where SPID=@@spid

select @Prc=Interest 
from tLoanInterest
where ObjectID=@ID
  and InterestType=100 
  and Date = (select max(Date) from tLoanInterest where ObjectID=@ID and InterestType=100 and Date<=@Date2)

select @LastDate=AL.Date
from tAccrualDetail AD 
join tADLink AL on AL.AccrualDetailID=AD.AccrualDetailID and AL.Type=0 and AL.ObjType in (44, 67)
where AD.ObjectID=@ID
  and AD.ObjectType=40

select @Payment=AL.Qty
from tAccrualDetail AD 
join tADLink AL on AL.AccrualDetailID=AD.AccrualDetailID and AL.Type=0 and AL.ObjType in (44, 67) and AL.Date=@LastDate
where AD.ObjectID=@ID
  and AD.ObjectType=40


select RecID    = '300100',                                                                        -- Rec = Account
       [310011] = @Account,                                                                        -- Consumer Account Number
       [310014] = convert(char(8),@DateStart,112),                                                 -- Account Open Date
       [310234] = cast(I.PropDealPart+1 as char(1)),                                               -- Account Class
       [310015] = replace(str(@AccCount,2,0),' ','0'),                                             -- Number of Account
       [310016] = @Val,                                                                            -- Currency Code
       [310019] = '',                                                                              -- Purpose of Finance
       [310022] = replace(str(D.Qty,15,0),' ','0'),                                                -- Amount of Finance
       [310024] = replace(str(datediff(month,D.DealDate,D.FixDate),3,0),' ','0'),                  -- Duration of Agreement
       [310248] = '03',                                                                            -- Duration Unit
       [310025] = '03',                                                                            -- Payment Frequency
       [310026] = replace(str(@Payment,15,0),' ','0'),                                             -- Installment Amount
       [310037] = '0',                                                                             -- Account Payment Status
       [310236] = '',                                                                              -- Type of Security
       [310237] = '1',                                                                             -- Insured Loan
       [310239] = replace(str(@Prc,8,3),' ','0'),                                                  -- Interest rate
       [310038] = replace(str(@Rest,15,0),' ','0'),                                                -- Total Outstanding Balance
       [310040] = replicate('0',15),                                                               -- Arrears Balance
       [310249] = convert(char(8),D.FixDate,112),                                                  -- Obligations fulfillment Due Date
       [310043] = convert(char(8),@LastDate,112),                                                  -- Date of Last Payment
       [310049] = '99',                                                                            -- Account Special Status
       [310055] = '0',                                                                             -- Record Block/Dispute Indicator
       [310455] = '',                                                                              -- Total Amount of Finance
       [310456] = '',                                                                              -- Secured Amount
       [310457] = '',                                                                              -- Security Start Date
       [310458] = '',                                                                              -- Security End Date
       [310459] = '',                                                                              -- Interest Payment date
       [310460] = '01',                                                                            -- Source of Payment
       [310462] = '1',                                                                             -- InfoPart Flag
       [310463] = '  '+rtrim(D.Number)+'  '+convert(char(10),D.DealDate,104),            -- Legal Account Number
       [310530] = '',                                                                              -- Total Cost of Finance in percents
       [310544] = DE.UUID,                                                                         -- Unique Loan Identifier
       [310545] = replace(str(@Rest,15,0),' ','0')                                                 -- Current Balance
from tDeal D
join tInstitution I on I.InstitutionID=D.InstitutionID
left join tLoanDealExt DE on DE.DealID=D.DealID
where D.DealID=@ID


select RecID    = '300630',                                                                        -- Rec = Warranty Record
       [310011] = @Account,                                                                        -- Consumer Account Number
       [310065] = replace(str(W.NumCons,2,0),' ','0'),                                             -- Account Holder Number
       [310480] = '  '+rtrim(D.Number)+'  '+convert(char(10),D.DealDate,104),            -- WarrantyAgreement Number
       [310016] = rtrim(C.Brief),                                                                  -- Currency
       [310022] = replace(str(D2.Qty,15,0),' ','0'),                                               -- Amount of Finance
       [310484] = replace(str(D.Qty,15,0),' ','0'),                                                -- Warranty Amount
       [310485] = convert(char(8),D.DealDate,112),                                                 -- Warranty Open date
       [310486] = convert(char(8),D.FixDate,112),                                                  -- Warranty Due date
       [310498] = replicate('0',15),                                                               -- Warranty Outstanding Balance
       [310491] = '0',                                                                             -- Warranty Payment Status
       [310492] = replicate('0',15),                                                               -- Warranty Arrears Balance
       [310546] = replace(str(W.Rest,15,0),' ','0'),                                               -- Warranty Current Balance
       [310544] = DE.UUID                                                                          -- Unique Loan Identifier
from #Warr W
join tDeal D on D.DealID=W.WarrID
join tCurrency C on C.CurrencyID=D.FundID
join tDeal D2 on D2.DealID=@ID
left join tDealWarranty DE on DE.DealID=D.DealID


select RecID    = '300300',                                                                        -- Rec = Consumer/Business Name Record
       [310011] = @Account,                                                                        -- Consumer Account Number
       [310065] = replace(str(C.NumCons,2,0),' ','0'),                                             -- Account Holder Number
       [310066] = case C.NumCons when 1 then '01' else '03' end,                                   -- Account Holder Type
       [310067] = case I.PropDealPart when 0 then '01' else '06' end,                              -- Primary ID Type
       [310068] = rtrim(IL.DocSeries)+rtrim(IL.NumDoc),                                            -- Primary ID Number
       [310133] = nullif(convert(char(8),IL.DateDoc,112),'19000101'),                              -- Primary ID Issue Date
       [310134] = rtrim(IL.Code),                                                                  -- Primary ID Place of Issue
       [310240] = IL.RegName,                                                                      -- Primary ID Authority
       [310072] = case I.PropDealPart when 0 then '08' else '09' end,                              -- Secondary ID Type
       [310073] = I.INN,                                                                           -- Consumer Account Number
       [310250] = '',                                                                              -- Pension Number
       [310075] = '1',                                                                             -- Supplied Name Format
       [310230] = I.Name1,                                                                         -- First Name/Short Company Name
       [310242] = I.Name2,                                                                         -- Patronymic/Foreign language company name
       [310233] = I.Name,                                                                          -- Surname/Company Name
       [310080] = case I.PropDealPart when 0 then str(I.Sex+1,1) else '3' end,                     -- Sex Code
       [310081] = nullif(convert(char(8),IA.BirthDay,112),'19000101'),                             -- Birth Date/Registration Date
       [310082] = IA.BirthPlace,                                                                   -- Place of Birth
       [310083] = tCountry.Alpha2,                                                                 -- Citizenship
       [310096] = rtrim(IC.Brief),                                                                 -- Mobile Telephone Number
       [310543] = rtrim(IL.Code)                                                                   -- Primary ID Authority Code
from #Cons C
join tInstitution I on I.InstitutionID=C.ConsID
left join tInstAttr IA on IA.InstitutionID=I.InstitutionID
left join tInstLicense IL on IL.InstitutionID=I.InstitutionID and IL.DocTypeID=20 and IL.isDefault=1
left join tCountry on tCountry.CountryID=I.CountryID
left join tInstContact IC on IC.InstitutionID=I.InstitutionID and IC.ContactTypeID=4 and IC.Flag=0


select RecID    = '300500',                                                                        -- Rec = Consumer Address Record
       [310011] = @Account,                                                                        -- Consumer Account Number
       [310065] = replace(str(C.NumCons,2,0),' ','0'),                                             -- Account Holder Number
       [310066] = case C.NumCons when 1 then '01' else '03' end,                                   -- Account Holder Type
       [310086] = '0',                                                                             -- Address Current/Previous Indicator
       [310087] = case T.Brief when '' then '1' 
                               when ''    then '2' 
                               when ''        then '4' end,                                -- Address Type
       [310090] = '1',                                                                             -- Supplied Address Format
       [310243] = A.Flat,                                                                          -- Flat Nr/Office Nr
       [310255] = A.House,                                                                         -- House Nr
       [310244] = A.Construction,                                                                  -- Building construction Nr
       [310225] = A.Street,                                                                        -- Prospect/Street/Lane
       [310226] = isnull(Town.Name,isnull(State.Name,Region.Brief)),                               -- Town/City
       [310227] = State.Name,                                                                      -- District/County/State
       [310245] = Region.CharCode,                                                                 -- Republic/Region
       [310206] = Country.Alpha2,                                                                  -- Country
       [310207] = A.PostIndex                                                                      -- Postal/Zip Code
from #Cons C
join tInstAddress A on A.InstitutionID=C.ConsID and A.Sign<2
join tAddressType T on T.AddressTypeID=A.AddressTypeID and T.Brief in('','','')
left join tCountry Town on Town.CountryID=A.CityID
left join tCountry State on State.CountryID=A.AreaID
left join tCountry Region on Region.CountryID=A.RegionID
left join tCountry Country on Country.CountryID=A.CountryID


select RecID    = '300660',                                                                        -- Rec = Lien Record
       [310011] = @Account,                                                                        -- Consumer Account Number
       [310511] = '  '+rtrim(D.Number)+'  '+convert(char(10),D.DealDate,104),            -- Lien Agreement Number
       [310512] = case when I.PropDealPart=1 then I.Name else I.Name+' '+I.Name1+' '+I.Name2
                  +isnull(',  '+IL.DocSeries+' '+IL.NumDoc+', . '
                  +convert(char(10),IL.DateDoc,104)+' '+IL.RegName+', / '+IL.Code,'') end,       -- Lienee name
       [310517] = replace(str(D.InstQty,15,0),' ','0'),                                            -- Collateral Estimated value
       [310016] = rtrim(C.Brief),                                                                  -- Currency
       [310520] = convert(char(8),D.DealDate,112),                                                 -- Lien Agreement Open date
       [310520] = convert(char(8),D.FixDate,112),                                                  -- Lien Agreement Due date
       [310523] = convert(char(8),D.FixDate,112),                                                  -- Collateral start date
       [310544] = DE.UUID                                                                          -- Unique Loan Identifier
from tWarrantyHistory DR
join tDeal D on D.DealID=DR.ChildID and D.DealDate<=@Date2 and D.ValueDate>=@Date2
join tInstrument FO on FO.InstrumentID=D.InstrumentID and FO.Brief in('')
join tCurrency C on C.CurrencyID=D.FundID
join tInstitution I on I.InstitutionID=D.InstitutionID
left join tInstLicense IL on IL.InstitutionID=I.InstitutionID and IL.DocTypeID=20 and IL.isDefault=1
left join tDealWarranty DE on DE.DealID=D.DealID
where DR.ParentID=@ID
  and DR.RelType=55
  and DR.OnDate<=@Date2
  and DR.DateLast>@Date2


drop table #Cons
drop table #Warr

return 0
