/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;

class ResultSetAccessor
extends Accessor {
    static final int MAXLENGTH = 16;
    OracleStatement currentStmt;

    ResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.RESULT_SET, stmt, 16, isStoredInBindData);
        this.init(stmt, 102, 116, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    ResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.RESULT_SET, stmt, 16, false);
        this.init(stmt, 102, 116, form, false);
        this.initForDescribe(102, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    ResultSet getCursor(int currentRow) throws SQLException {
        OracleResultSet rset = null;
        if (this.currentStmt != null && this.currentStmt.refCursorRowNumber == currentRow && !this.currentStmt.isClosed()) {
            rset = this.currentStmt.createResultSet();
        } else {
            byte[] bytes = this.getBytes(currentRow);
            if (bytes != null) {
                OracleStatement newstmt = this.statement.connection.RefCursorBytesToStatement(bytes, this.statement);
                newstmt.refCursorRowNumber = currentRow;
                newstmt.doDescribe(false);
                if (newstmt.numberOfDefinePositions > 0) {
                    newstmt.prepareAccessors();
                }
                newstmt.setPrefetchInternal(this.statement.getFetchSize(), false, false);
                newstmt.closeOnCompletion();
                newstmt.currentResultSet = rset = newstmt.createResultSet();
                this.currentStmt = newstmt;
            }
        }
        return rset;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getCursor(currentRow);
    }
}

