/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import ru.ovs.jsqlmonitor.ColorInfo;

class ColorsPanel
extends JToolBar {
    void updateColors(ArrayList<ColorInfo> colors) {
        this.removeAll();
        for (ColorInfo color : colors) {
            JTextField tb = new JTextField(String.valueOf(color.getNum()));
            tb.setEditable(false);
            tb.setMaximumSize(new Dimension(100, 22));
            tb.setPreferredSize(new Dimension(100, 22));
            tb.setHorizontalAlignment(4);
            tb.setBackground(color.getColor());
            tb.setFont(new Font(tb.getFont().getName(), 1, tb.getFont().getSize()));
            tb.setFocusable(false);
            tb.setBorder(BorderFactory.createLineBorder(tb.getBackground().darker()));
            this.add(tb);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    ColorsPanel() {
        this.setOrientation(1);
        this.setPreferredSize(new Dimension(50, 0));
        this.setFloatable(false);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }
}

