/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import ru.ovs.jsqlmonitor.JSQLMonitor;
import ru.ovs.jsqlmonitor.Server;
import ru.ovs.jsqlmonitor.Utils;
import ru.ovs.jsqlmonitor.XMLProc;

public class ConnEditForm
extends JDialog {
    private Server server;
    private int maxHeight;
    private JToggleButton btnCancel;
    private JButton btnOK;
    private JButton btnOpen;
    private JCheckBox chKerberos;
    private JCheckBox chReadOnly;
    private JCheckBox chSavePassw;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JTextField txClassName;
    private JTextField txConnName;
    private JTextField txConnectionString;
    private JTextField txDriver;
    private JPasswordField txPassword;
    private JTextField txSQLScript;
    private JTextField txUser;

    void updateServer() {
        Utils.wipeCharArray(this.server.password);
        this.server.name = this.txConnName.getText();
        this.server.user = this.txUser.getText();
        this.server.sqlScript = this.txSQLScript.getText();
        this.server.connString = this.txConnectionString.getText();
        this.server.password = this.chSavePassw.isSelected() ? this.txPassword.getPassword() : null;
        this.server.readOnly = this.chReadOnly.isSelected();
        this.server.kerberos = this.chKerberos.isSelected();
        JSQLMonitor.mainForm.srvListModel.update(JSQLMonitor.mainForm.getCurrentIndex());
        XMLProc.saveConnections();
    }

    private void setOKEnabled() {
        boolean changed = !this.txConnName.getText().equals(this.server.name) | !this.txUser.getText().equals(this.server.user) | !this.txSQLScript.getText().equals(this.server.sqlScript) | !this.txConnectionString.getText().equals(this.server.connString) | this.chSavePassw.isSelected() != this.server.passwSaved() | this.chReadOnly.isSelected() != this.server.readOnly | this.chKerberos.isSelected() != this.server.kerberos | !Arrays.equals(this.txPassword.getPassword(), this.server.password) & this.chSavePassw.isSelected();
        this.btnOK.setEnabled(changed &= !Utils.isBlank(this.txConnName.getText()));
    }

    public ConnEditForm(Server aServer) {
        super(JSQLMonitor.mainForm, "Edit connection", true);
        this.initComponents();
        this.server = aServer;
        this.txDriver.setText(this.server.drvName);
        if (this.server.driver != null) {
            this.txClassName.setText(this.server.driver.drvClass);
        }
        this.txSQLScript.setText(this.server.sqlScript);
        this.txConnName.setText(this.server.name);
        this.txUser.setText(this.server.user);
        this.chReadOnly.setSelected(this.server.readOnly);
        this.chKerberos.setSelected(this.server.kerberos);
        this.txConnectionString.setText(this.server.connString);
        if (this.server.passwSaved()) {
            this.txPassword.setText(String.valueOf(this.server.password));
            this.chSavePassw.setSelected(true);
        }
        this.chKerberos.setEnabled(this.server.driver != null && this.server.driver.canKerberosAuth());
        this.chKerberosActionPerformed(null);
        this.txConnName.getDocument().addDocumentListener(() -> this.setOKEnabled());
        this.txUser.getDocument().addDocumentListener(() -> this.setOKEnabled());
        this.txPassword.getDocument().addDocumentListener(() -> this.setOKEnabled());
        this.txSQLScript.getDocument().addDocumentListener(() -> this.setOKEnabled());
        this.txConnectionString.getDocument().addDocumentListener(() -> this.setOKEnabled());
        this.getRootPane().registerKeyboardAction(evt -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.txConnectionString.moveCaretPosition(0);
        this.txConnName.requestFocusInWindow();
        this.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        this.maxHeight = this.getHeight();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.txDriver = new JTextField();
        this.txClassName = new JTextField();
        this.txConnName = new JTextField();
        this.txUser = new JTextField();
        this.txConnectionString = new JTextField();
        this.chSavePassw = new JCheckBox();
        this.btnCancel = new JToggleButton();
        this.btnOK = new JButton();
        this.jLabel7 = new JLabel();
        this.txPassword = new JPasswordField();
        this.chKerberos = new JCheckBox();
        this.chReadOnly = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.txSQLScript = new JTextField();
        this.btnOpen = new JButton();
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ConnEditForm.this.formComponentResized(evt);
            }
        });
        this.jLabel1.setText("JDBC driver:");
        this.jLabel2.setText("Class name:");
        this.jLabel3.setText("Name:");
        this.jLabel5.setText("Password:");
        this.jLabel6.setText("Connection string");
        this.txDriver.setEditable(false);
        this.txClassName.setEditable(false);
        this.chSavePassw.setText("Save");
        this.chSavePassw.setToolTipText("The password will be saved in plain text");
        this.chSavePassw.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConnEditForm.this.chSavePasswStateChanged(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnEditForm.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOK.setText("OK");
        this.btnOK.setEnabled(false);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnEditForm.this.btnOKActionPerformed(evt);
            }
        });
        this.jLabel7.setText("User name:");
        this.chKerberos.setText("Integrated security");
        this.chKerberos.setToolTipText("Only for MS SQL Server");
        this.chKerberos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnEditForm.this.chKerberosActionPerformed(evt);
            }
        });
        this.chReadOnly.setText("Set read-only connection");
        this.chReadOnly.setToolTipText("If the jdbc driver supports this mode");
        this.chReadOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnEditForm.this.chReadOnlyActionPerformed(evt);
            }
        });
        this.jLabel8.setText("SQL script");
        this.btnOpen.setText("...");
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnEditForm.this.btnOpenActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.chReadOnly)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txConnectionString).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel7).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txClassName).addComponent(this.txConnName).addComponent(this.txDriver, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txPassword, -1, 135, Short.MAX_VALUE).addComponent(this.txUser)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chKerberos).addComponent(this.chSavePassw))))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.txSQLScript).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpen, -2, 24, -2))))).addContainerGap()));
        layout.linkSize(0, this.btnCancel, this.btnOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txDriver, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txClassName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txConnName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txUser, -2, -1, -2).addComponent(this.chKerberos)).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txPassword, -2, -1, -2).addComponent(this.chSavePassw))).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txConnectionString, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chReadOnly).addGap(18, 18, 18).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txSQLScript, -2, -1, -2).addComponent(this.btnOpen, -2, 20, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.updateServer();
        this.dispose();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (evt.getComponent().getHeight() > this.maxHeight) {
            this.setSize(evt.getComponent().getWidth(), this.maxHeight);
        }
    }

    private void chSavePasswStateChanged(ChangeEvent evt) {
        this.setOKEnabled();
    }

    private void chKerberosActionPerformed(ActionEvent evt) {
        this.txUser.setEnabled(!this.chKerberos.isSelected());
        this.txPassword.setEnabled(!this.chKerberos.isSelected());
        this.chSavePassw.setEnabled(!this.chKerberos.isSelected());
        this.setOKEnabled();
    }

    private void chReadOnlyActionPerformed(ActionEvent evt) {
        this.setOKEnabled();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        JFileChooser foDialog = new JFileChooser();
        foDialog.setFileFilter(new FileNameExtensionFilter("SQL Files", "sql"));
        foDialog.setCurrentDirectory(new File(this.txSQLScript.getText()).getParentFile());
        if (foDialog.showDialog(this, "Select File") == 0) {
            this.txSQLScript.setText(foDialog.getSelectedFile().getAbsolutePath());
        }
    }
}

