/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.NumberFormatter;
import ru.ovs.jsqlmonitor.Driver;
import ru.ovs.jsqlmonitor.JSQLMonitor;
import ru.ovs.jsqlmonitor.Server;
import ru.ovs.jsqlmonitor.ServerState;
import ru.ovs.jsqlmonitor.Utils;
import ru.ovs.jsqlmonitor.XMLProc;

public class ConnNewForm
extends JDialog {
    private int maxHeight;
    private JButton btnCancel;
    private JButton btnOK;
    private JButton btnOpen;
    private JButton btnTest;
    private JComboBox<Driver> cbDriver;
    private JCheckBox chKerberos;
    private JCheckBox chReadOnly;
    private JCheckBox chSavePassw;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTextField txConnName;
    private JTextField txConnectionString;
    private JTextField txDatabase;
    private JTextField txHost;
    private JPasswordField txPassword;
    private JFormattedTextField txPort;
    private JTextField txSQLScript;
    private JTextField txUser;

    private NumberFormatter getPortFormatter() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        NumberFormatter portFormatter = new NumberFormatter(numberFormat);
        portFormatter.setValueClass(Integer.class);
        portFormatter.setMaximum(Integer.valueOf(65535));
        portFormatter.setAllowsInvalid(false);
        portFormatter.setCommitsOnValidEdit(true);
        return portFormatter;
    }

    private String getDrvName() {
        Driver driver = (Driver)this.cbDriver.getSelectedItem();
        return driver == null ? "" : driver.drvName;
    }

    private String getDrvScript() {
        Driver driver = (Driver)this.cbDriver.getSelectedItem();
        return driver == null ? "" : driver.sqlScript;
    }

    private boolean needShowKerberos() {
        Driver driver = (Driver)this.cbDriver.getSelectedItem();
        return driver != null && driver.canKerberosAuth();
    }

    private char[] getPassword() {
        return this.chSavePassw.isSelected() ? this.txPassword.getPassword() : null;
    }

    private void updateConnString() {
        Driver driver = (Driver)this.cbDriver.getSelectedItem();
        this.txConnectionString.setText(driver == null ? "" : driver.getConnectionString(this.txHost.getText(), this.txPort.getText(), this.txDatabase.getText()));
        this.txConnectionString.setCaretPosition(0);
    }

    private void updateConnName() {
        this.setOKEnabled();
    }

    private void addServer() {
        JSQLMonitor.mainForm.srvListModel.add(JSQLMonitor.mainForm.srvListModel.getSize(), new Server(this.getDrvName(), this.txConnName.getText(), this.txUser.getText(), this.getPassword(), this.chKerberos.isSelected(), this.txConnectionString.getText(), this.chReadOnly.isSelected(), this.txSQLScript.getText()));
        JSQLMonitor.mainForm.setLastSelected();
        XMLProc.saveConnections();
    }

    private void setOKEnabled() {
        this.btnOK.setEnabled(this.cbDriver.getSelectedItem() != null & !Utils.isBlank(this.txConnName.getText()));
    }

    public ConnNewForm() {
        super(JSQLMonitor.mainForm, "New connection", true);
        this.initComponents();
        this.cbDriver.setModel(new DefaultComboBoxModel<Driver>(JSQLMonitor.drvList.toArray(new Driver[0])));
        this.txHost.getDocument().addDocumentListener(() -> this.updateConnString());
        this.txPort.getDocument().addDocumentListener(() -> this.updateConnString());
        this.txDatabase.getDocument().addDocumentListener(() -> this.updateConnString());
        this.txConnName.getDocument().addDocumentListener(() -> this.updateConnName());
        this.getRootPane().registerKeyboardAction(evt -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.cbDriver.setSelectedIndex(-1);
        this.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        this.maxHeight = this.getHeight();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbDriver = new JComboBox();
        this.jLabel2 = new JLabel();
        this.txHost = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.txDatabase = new JTextField();
        this.jLabel5 = new JLabel();
        this.txUser = new JTextField();
        this.jLabel6 = new JLabel();
        this.txPassword = new JPasswordField();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.txPort = new JFormattedTextField(this.getPortFormatter());
        this.jLabel7 = new JLabel();
        this.txConnectionString = new JTextField();
        this.chSavePassw = new JCheckBox();
        this.txConnName = new JTextField();
        this.jLabel9 = new JLabel();
        this.chKerberos = new JCheckBox();
        this.btnTest = new JButton();
        this.chReadOnly = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.txSQLScript = new JTextField();
        this.btnOpen = new JButton();
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(0, 0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ConnNewForm.this.formComponentResized(evt);
            }
        });
        this.jLabel1.setText("JDBC driver:");
        this.cbDriver.setMaximumRowCount(20);
        this.cbDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnNewForm.this.cbDriverActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Host:");
        this.jLabel3.setText("Port:");
        this.jLabel4.setText("Database:");
        this.jLabel5.setText("User name:");
        this.jLabel6.setText("Password:");
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnNewForm.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOK.setText("OK");
        this.btnOK.setEnabled(false);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnNewForm.this.btnOKActionPerformed(evt);
            }
        });
        this.txPort.setHorizontalAlignment(4);
        this.jLabel7.setText("Connection string");
        this.chSavePassw.setText("Save");
        this.chSavePassw.setToolTipText("The password will be saved in plain text");
        this.jLabel9.setText("Name:");
        this.chKerberos.setText("Integrated security");
        this.chKerberos.setToolTipText("Only for MS SQL Server");
        this.chKerberos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnNewForm.this.chKerberosActionPerformed(evt);
            }
        });
        this.btnTest.setText("Test connection");
        this.btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnNewForm.this.btnTestActionPerformed(evt);
            }
        });
        this.chReadOnly.setSelected(true);
        this.chReadOnly.setText("Set read-only connection");
        this.chReadOnly.setToolTipText("If the jdbc driver supports this mode");
        this.jLabel8.setText("SQL script");
        this.btnOpen.setText("...");
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnNewForm.this.btnOpenActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.chReadOnly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnTest)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.txConnectionString).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel9).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jLabel5, -2, 72, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txConnName, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.txHost).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txPort, -2, 52, -2)).addComponent(this.txDatabase, GroupLayout.Alignment.TRAILING).addComponent(this.cbDriver, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txPassword, -1, 185, Short.MAX_VALUE).addComponent(this.txUser)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chKerberos).addComponent(this.chSavePassw))))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.txSQLScript).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpen, -2, 24, -2))).addContainerGap()))));
        layout.linkSize(0, this.btnCancel, this.btnOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDriver, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txConnName, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txHost, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.txPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.txDatabase, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.txUser, -2, -1, -2).addComponent(this.chKerberos)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.txPassword, -2, -1, -2).addComponent(this.chSavePassw)).addGap(18, 18, 18).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txConnectionString, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chReadOnly).addComponent(this.btnTest)).addGap(18, 18, 18).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnOpen, -2, 20, -2).addComponent(this.txSQLScript, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK).addComponent(this.btnCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.addServer();
        this.dispose();
    }

    private void cbDriverActionPerformed(ActionEvent evt) {
        this.updateConnString();
        this.txSQLScript.setText(this.getDrvScript());
        this.txConnName.setText(this.getDrvName());
        this.txConnName.selectAll();
        this.txConnName.requestFocus();
        this.chKerberos.setSelected(false);
        this.chKerberos.setEnabled(this.needShowKerberos());
        this.chKerberosActionPerformed(null);
        this.btnTest.setEnabled(this.cbDriver.getSelectedItem() != null);
        this.setOKEnabled();
    }

    private void formComponentResized(ComponentEvent evt) {
        if (evt.getComponent().getHeight() > this.maxHeight) {
            this.setSize(evt.getComponent().getWidth(), this.maxHeight);
        }
    }

    private void chKerberosActionPerformed(ActionEvent evt) {
        this.txUser.setEnabled(!this.chKerberos.isSelected());
        this.txPassword.setEnabled(!this.chKerberos.isSelected());
        this.chSavePassw.setEnabled(!this.chKerberos.isSelected());
    }

    private void btnTestActionPerformed(ActionEvent evt) {
        Server lcServer = new Server(this.getDrvName(), this.getDrvName(), this.txUser.getText(), this.txPassword.getPassword(), this.chKerberos.isSelected(), this.txConnectionString.getText(), this.chReadOnly.isSelected(), "");
        if (lcServer.state == ServerState.NoDriver) {
            Utils.ShowWarning("No class name found for the selected driver.");
        } else if (lcServer.connect()) {
            Utils.ShowMessage("Connection successfull.");
            lcServer.disconnect();
        }
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        JFileChooser foDialog = new JFileChooser();
        foDialog.setFileFilter(new FileNameExtensionFilter("SQL Files", "sql"));
        foDialog.setCurrentDirectory(new File(this.txSQLScript.getText()).getParentFile());
        if (foDialog.showDialog(this, "Select File") == 0) {
            this.txSQLScript.setText(foDialog.getSelectedFile().getAbsolutePath());
        }
    }
}

