/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.MouseInfo;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import ru.ovs.jsqlmonitor.ActConnect;
import ru.ovs.jsqlmonitor.ActDisconnect;
import ru.ovs.jsqlmonitor.ActSrvDelete;
import ru.ovs.jsqlmonitor.ActSrvEdit;
import ru.ovs.jsqlmonitor.ActSrvNew;
import ru.ovs.jsqlmonitor.ColorInfo;
import ru.ovs.jsqlmonitor.ColorsPanel;
import ru.ovs.jsqlmonitor.ColumnsForm;
import ru.ovs.jsqlmonitor.JSQLMonitor;
import ru.ovs.jsqlmonitor.LaFList;
import ru.ovs.jsqlmonitor.PeriodComboBox;
import ru.ovs.jsqlmonitor.Server;
import ru.ovs.jsqlmonitor.ServerState;
import ru.ovs.jsqlmonitor.ServerTransferable;
import ru.ovs.jsqlmonitor.Settings;
import ru.ovs.jsqlmonitor.SrvList;
import ru.ovs.jsqlmonitor.SrvListModel;
import ru.ovs.jsqlmonitor.Table;
import ru.ovs.jsqlmonitor.TableDataModel;
import ru.ovs.jsqlmonitor.TableRenderer;
import ru.ovs.jsqlmonitor.Utils;
import ru.ovs.jsqlmonitor.ViewCellForm;
import ru.ovs.jsqlmonitor.Worker;
import ru.ovs.jsqlmonitor.XMLProc;

public class MainForm
extends JFrame {
    private ActSrvNew actSrvNew;
    private ActSrvEdit actSrvEdit;
    private ActSrvDelete actSrvDelete;
    private ActConnect actSrvConnect;
    private ActDisconnect actSrvDisconnect;
    private JList<Server> srvList;
    private JTable monitorTable;
    private PeriodComboBox cbPeriod;
    private ImageIcon[] srvIcons;
    private Worker worker = new Worker();
    private Table table = new Table();
    private TableDataModel dataModel = new TableDataModel(this.table);
    private boolean flError;
    private Server curServer;
    private boolean flFilterListUpdating;
    private LaFList lafList = new LaFList();
    private int curLaFIdx;
    private ColorsPanel colorsPanel;
    SrvListModel<Server> srvListModel;
    Settings settings = new Settings();
    private ButtonGroup bgDTFormat;
    private JButton btnConnect;
    private JButton btnDelFilter;
    private JButton btnDisconnect;
    private JButton btnSrvDelete;
    private JButton btnSrvEdit;
    private JButton btnSrvNew;
    private JComboBox<String> cbFilter;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JSplitPane mainSplitPane;
    private JMenuItem mnAdjustColumns;
    private JMenuItem mnConnect;
    private JMenuItem mnCopy;
    private JMenu mnDTFormat;
    private JRadioButtonMenuItem mnDTFormat0;
    private JRadioButtonMenuItem mnDTFormat1;
    private JMenuItem mnDisconnect;
    private JMenuItem mnFilter;
    private JCheckBoxMenuItem mnFontBold;
    private JMenu mnFonts;
    private JMenuItem mnHideSrvPanel;
    private JMenuItem mnRestColumns;
    private JMenuItem mnSelectColumns;
    private JMenuItem mnSrvDelete;
    private JMenuItem mnSrvEdit;
    private JMenuItem mnSrvNew;
    private JMenu mnThemes;
    private JPanel monitorPanel;
    private JScrollPane monitorScrollPane;
    private JPanel monitorStatusBar;
    private JToolBar monitorToolBar;
    private JPopupMenu srvMenu;
    private JPanel srvPanel;
    private JScrollPane srvScrollPane;
    private JPanel srvStatusBar;
    private JToolBar srvToolBar;
    private JPopupMenu tableHeaderMenu;
    private JPopupMenu tableMenu;
    private JToggleButton tbColors;
    private JButton tbExit;
    private JToggleButton tbPause;
    private JButton tbRefresh;
    private JTextField txConnProp;
    private JTextField txConnString;
    private JTextField txFilter;
    private JTextField txRecCount;
    private JTextField txSrvStatus;

    Server getCurrentServer() {
        return this.srvList.getSelectedValue();
    }

    int getCurrentIndex() {
        return this.srvList.getSelectedIndex();
    }

    int getColumnCount() {
        return this.monitorTable.getColumnCount();
    }

    String getColumnName(int col) {
        return this.monitorTable.getColumnName(col);
    }

    boolean isVisibleColumn(int col) {
        return this.monitorTable.getColumnModel().getColumn(col).getWidth() != 0;
    }

    private boolean canManageColumns() {
        return this.curServer != null && !this.flError && this.getColumnCount() != 0;
    }

    String getCurrentLaFName() {
        return this.lafList.getLaFName(this.curLaFIdx);
    }

    void setFirstSelected() {
        if (this.srvListModel.getSize() != 0) {
            this.srvList.setSelectedIndex(0);
        } else {
            this.tuneActions();
        }
    }

    void setLastSelected() {
        if (this.srvListModel.getSize() != 0) {
            this.srvList.setSelectedIndex(this.srvListModel.getSize() - 1);
        } else {
            this.tuneActions();
        }
    }

    private void loadSrvImages() {
        this.srvIcons = new ImageIcon[4];
        this.srvIcons[0] = JSQLMonitor.getIcon("bled.png");
        this.srvIcons[1] = JSQLMonitor.getIcon("gled.png");
        this.srvIcons[2] = JSQLMonitor.getIcon("rled.png");
        this.srvIcons[3] = JSQLMonitor.getIcon("yled.png");
    }

    private void setInitLaf() {
        UIManager.put("swing.boldMetal", this.settings.fbold);
        this.curLaFIdx = this.lafList.getLafIdx(this.settings.theme);
        if (this.curLaFIdx < 0) {
            this.curLaFIdx = 0;
        }
        if (this.curLaFIdx != 0 && !this.setLaF(this.curLaFIdx)) {
            this.curLaFIdx = 0;
        }
    }

    private void setLaFCorrection() {
        if (this.monitorTable == null) {
            return;
        }
        this.monitorToolBar.setLayout(new BoxLayout(this.monitorToolBar, 0));
        this.mainSplitPane.setDividerLocation(-1);
        this.monitorTable.getTableHeader().setFont(new Font(this.monitorTable.getFont().getName(), 1, this.monitorTable.getFont().getSize()));
        this.monitorTable.setIntercellSpacing(new Dimension(1, 1));
        this.monitorTable.setGridColor(Color.GRAY);
        this.monitorTable.setShowGrid(true);
    }

    boolean setLaF(int idx) {
        boolean result = true;
        try {
            if ("Ocean".equals(this.lafList.getLaFTheme(idx))) {
                MetalLookAndFeel.setCurrentTheme(new OceanTheme());
            }
            if ("Steel".equals(this.lafList.getLaFTheme(idx))) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            UIManager.setLookAndFeel(this.lafList.getLaFClassName(idx));
        }
        catch (Exception exc) {
            result = false;
            Utils.ShowError("Unable to set UI Theme \"" + this.lafList.getLaFName(idx) + "\". Exception: \n" + exc.getClass());
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.setLaFCorrection();
        return result;
    }

    private void createThemeMenu() {
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < this.lafList.getLaFsCount(); ++i) {
            AuxRadioButtonMenuItem mn = new AuxRadioButtonMenuItem(this.lafList.getLaFName(i));
            bg.add(this.mnThemes.add(mn));
            mn.idx = i;
            mn.setSelected(this.curLaFIdx == i);
            mn.addActionListener(evt -> {
                if (!this.setLaF(mn.idx)) {
                    this.mnThemes.getItem(this.curLaFIdx).setSelected(true);
                } else {
                    this.curLaFIdx = mn.idx;
                    this.mnFonts.setEnabled(this.lafList.getLaFTheme(mn.idx) != null);
                }
            });
        }
        this.mnFonts.setEnabled(this.lafList.getLaFTheme(this.curLaFIdx) != null);
    }

    private void hideSrvPanel() {
        this.mainSplitPane.setDividerLocation(this.mainSplitPane.getDividerLocation() <= 1 ? this.mainSplitPane.getLastDividerLocation() : 0);
    }

    void updateStatusBars() {
        Server server = this.getCurrentServer();
        if (server == null) {
            this.txSrvStatus.setText("");
            this.txConnString.setText("");
        } else {
            this.txSrvStatus.setText(server.name);
            this.txConnProp.setText(server.getConnectionInfo());
            this.txConnString.setText(server.connString);
        }
    }

    void updateRecCount() {
        this.txRecCount.setText(this.canManageColumns() ? String.valueOf(this.monitorTable.getRowCount()) : "");
        this.txRecCount.setForeground(((TableRowSorter)this.monitorTable.getRowSorter()).getRowFilter() == null ? Color.BLUE : Color.MAGENTA);
    }

    void tuneActions() {
        Server server = this.getCurrentServer();
        if (server == null) {
            this.actSrvEdit.setEnabled(false);
            this.actSrvDelete.setEnabled(false);
            this.actSrvConnect.setEnabled(false);
            this.actSrvDisconnect.setEnabled(false);
        } else {
            this.actSrvEdit.setEnabled(server.state != ServerState.Connected);
            this.actSrvDelete.setEnabled(server.state != ServerState.Connected);
            this.actSrvConnect.setEnabled(server.state != ServerState.Connected && server.state != ServerState.NoDriver);
            this.actSrvDisconnect.setEnabled(server.state == ServerState.Connected);
        }
        this.updateStatusBars();
    }

    String getStrValue() {
        Object lcObj = null;
        if (this.monitorTable.getSelectedRow() != -1 && this.monitorTable.getSelectedColumn() != -1) {
            lcObj = this.monitorTable.getValueAt(this.monitorTable.getSelectedRow(), this.monitorTable.getSelectedColumn());
        }
        return lcObj == null ? "" : lcObj.toString();
    }

    void copyCell() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.getStrValue()), null);
    }

    void monitoring(Server aServer) {
        this.worker.setPause(true);
        long curTime = System.currentTimeMillis();
        while (!this.worker.waiting) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - curTime <= 10000L) continue;
            Utils.ShowError("Can't interrupt thread. Program will be closed.");
            System.exit(0);
        }
        this.worker.setStatement(aServer == null || !aServer.connected() ? null : aServer.getStatement(), aServer);
        this.worker.setPause(false);
        this.tbPause.setSelected(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMonitor(boolean updateHeader, boolean aError, Server aServer) {
        Object object = this.worker.sync;
        synchronized (object) {
            this.table.updateTable(this.worker.getBuffer(), updateHeader);
        }
        this.flError = aError;
        int lcRow = this.monitorTable.getSelectedRow();
        int lcCol = this.monitorTable.getSelectedColumn();
        if (updateHeader) {
            if (this.flError) {
                this.monitorTable.setAutoResizeMode(4);
            } else if (this.monitorTable.getAutoResizeMode() != 0) {
                this.monitorTable.setAutoResizeMode(0);
            }
            this.packSrvColumns();
            this.curServer = aServer;
            this.resetColumns();
            this.fillFilterFields();
            this.unpackSrvColumns();
            lcRow = -1;
            lcCol = -1;
        }
        this.dataModel.fireTableDataChanged();
        try {
            this.monitorTable.setRowSelectionInterval(lcRow, lcRow);
            this.monitorTable.setColumnSelectionInterval(lcCol, lcCol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateColorsStat();
        this.updateRecCount();
    }

    void showViewCell() {
        ViewCellForm viewCellForm = new ViewCellForm((Frame)JSQLMonitor.mainForm, this.getColumnName(this.monitorTable.getSelectedColumn()), this.getStrValue());
        viewCellForm.setLocationRelativeTo(JSQLMonitor.mainForm);
        viewCellForm.setSize(new Dimension(this.settings.vcwidth, this.settings.vcheight));
        viewCellForm.setVisible(true);
    }

    ArrayList<ColorInfo> getColors() {
        int nullColor = this.monitorTable.getBackground().getRGB();
        ArrayList<ColorInfo> result = new ArrayList<ColorInfo>();
        int[] colors = new int[this.monitorTable.getRowCount()];
        for (int i = 0; i < colors.length; ++i) {
            Integer lcColor = this.table.getColor(this.monitorTable.convertRowIndexToModel(i));
            colors[i] = lcColor == null ? nullColor : lcColor;
        }
        Arrays.sort(colors);
        int lcColor = 0;
        ColorInfo lcColorInfo = null;
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] != lcColor || i == 0) {
                lcColor = colors[i];
                lcColorInfo = new ColorInfo(lcColor);
                result.add(lcColorInfo);
                continue;
            }
            lcColorInfo.inc();
        }
        result.sort((c1, c2) -> Integer.compare(c1.getNum(), c2.getNum()));
        return result;
    }

    void updateColorsStat() {
        if (this.colorsPanel.isVisible()) {
            this.colorsPanel.updateColors(this.getColors());
        }
    }

    void fillFilterFields() {
        this.flFilterListUpdating = true;
        this.cbFilter.removeAllItems();
        if (this.canManageColumns()) {
            String[] columns;
            this.cbFilter.addItem("<all fields>");
            for (String column : columns = this.dataModel.getSortedColmnsList()) {
                this.cbFilter.addItem(column);
            }
        }
        this.flFilterListUpdating = false;
        this.txFilter.setText("");
    }

    void setFilterByCell() {
        if (this.monitorTable.getSelectedColumn() == -1) {
            return;
        }
        int lcIdx = 0;
        for (int i = 1; i < this.cbFilter.getItemCount(); ++i) {
            if (!this.monitorTable.getColumnName(this.monitorTable.getSelectedColumn()).equals(this.cbFilter.getItemAt(i))) continue;
            lcIdx = i;
            break;
        }
        if (lcIdx > 0) {
            this.txFilter.setText(this.getStrValue());
            this.cbFilter.setSelectedIndex(lcIdx);
            this.monitorTable.requestFocus();
        }
    }

    void applyFilter() {
        if (this.cbFilter.getSelectedIndex() < 0 || this.txFilter.getText().length() == 0) {
            ((TableRowSorter)this.monitorTable.getRowSorter()).setRowFilter(null);
        } else if (this.cbFilter.getSelectedIndex() == 0) {
            try {
                RowFilter filter = RowFilter.regexFilter(this.txFilter.getText(), new int[0]);
                ((TableRowSorter)this.monitorTable.getRowSorter()).setRowFilter(filter);
            }
            catch (Exception exc) {
                Utils.ShowError(exc.getMessage());
            }
        } else {
            int col = this.dataModel.getColumnByName(this.cbFilter.getSelectedItem().toString());
            if (col != -1) {
                try {
                    RowFilter filter = RowFilter.regexFilter(this.txFilter.getText(), col);
                    ((TableRowSorter)this.monitorTable.getRowSorter()).setRowFilter(filter);
                }
                catch (Exception exc) {
                    Utils.ShowError(exc.getMessage());
                }
            }
        }
        this.updateColorsStat();
        this.updateRecCount();
    }

    private void adjustColumnsWidth() {
        for (int col = 0; col < this.monitorTable.getColumnModel().getColumnCount(); ++col) {
            int maxWidth = this.monitorTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this.monitorTable, (Object)this.monitorTable.getColumnName((int)col), (boolean)false, (boolean)false, (int)-1, (int)col).getPreferredSize().width;
            for (int row = 0; row < this.monitorTable.getRowCount(); ++row) {
                maxWidth = Math.max(this.monitorTable.prepareRenderer((TableCellRenderer)this.monitorTable.getCellRenderer((int)row, (int)col), (int)row, (int)col).getPreferredSize().width, maxWidth);
            }
            maxWidth = Math.min(maxWidth, 500);
            this.monitorTable.getColumnModel().getColumn(col).setPreferredWidth(maxWidth + this.monitorTable.getIntercellSpacing().width + 4);
        }
    }

    void showColumn(int col, boolean show) {
        if (show) {
            this.monitorTable.getColumnModel().getColumn(col).setMinWidth(0);
            this.monitorTable.getColumnModel().getColumn(col).setMaxWidth(Integer.MAX_VALUE);
            this.monitorTable.getColumnModel().getColumn(col).setPreferredWidth((Integer)this.monitorTable.getColumnModel().getColumn(col).getIdentifier());
        } else {
            this.monitorTable.getColumnModel().getColumn(col).setIdentifier(this.monitorTable.getColumnModel().getColumn(col).getWidth());
            this.monitorTable.getColumnModel().getColumn(col).setMinWidth(0);
            this.monitorTable.getColumnModel().getColumn(col).setMaxWidth(0);
            this.monitorTable.getColumnModel().getColumn(col).setWidth(0);
        }
    }

    private void resetColumns() {
        this.dataModel.fireTableStructureChanged();
        for (int i = 0; i < this.monitorTable.getColumnCount(); ++i) {
            this.monitorTable.getColumnModel().getColumn(i).setCellRenderer(TableRenderer.renderer);
        }
    }

    private void packSrvColumns() {
        if (!this.canManageColumns()) {
            return;
        }
        this.curServer.fltCol = this.cbFilter.getSelectedIndex();
        this.curServer.fltText = this.txFilter.getText();
        if (this.getColumnCount() != this.curServer.columns.size()) {
            this.curServer.columns.clear();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                ArrayList<Integer> pair = new ArrayList<Integer>(2);
                pair.add(this.monitorTable.getColumnModel().getColumn(i).getWidth());
                pair.add(this.monitorTable.getColumnModel().getColumn(i).getModelIndex());
                this.curServer.columns.add(pair);
            }
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                int width = this.monitorTable.getColumnModel().getColumn(i).getWidth();
                if (width == 0) {
                    width = -((Integer)this.monitorTable.getColumnModel().getColumn(i).getIdentifier()).intValue();
                }
                this.curServer.columns.get(i).set(0, width);
                this.curServer.columns.get(i).set(1, this.monitorTable.getColumnModel().getColumn(i).getModelIndex());
            }
        }
    }

    private void unpackSrvColumns() {
        if (!this.canManageColumns()) {
            return;
        }
        this.txFilter.setText("");
        this.flFilterListUpdating = true;
        this.cbFilter.setSelectedIndex(0);
        if (this.cbFilter.getItemCount() > this.curServer.fltCol && this.curServer.fltCol != -1) {
            this.cbFilter.setSelectedIndex(this.curServer.fltCol);
            if (this.curServer.fltText.length() != 0) {
                this.txFilter.setText(this.curServer.fltText);
                this.applyFilter();
            }
        }
        this.flFilterListUpdating = false;
        if (this.getColumnCount() != this.curServer.columns.size()) {
            this.packSrvColumns();
            return;
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int width = this.curServer.columns.get(i).get(0);
            if (width > 0) {
                this.monitorTable.getColumnModel().getColumn(i).setPreferredWidth(width);
            } else {
                this.monitorTable.getColumnModel().getColumn(i).setIdentifier(-width);
                this.monitorTable.getColumnModel().getColumn(i).setMinWidth(0);
                this.monitorTable.getColumnModel().getColumn(i).setMaxWidth(0);
                this.monitorTable.getColumnModel().getColumn(i).setWidth(0);
            }
            int modelIndex = this.curServer.columns.get(i).get(1);
            this.monitorTable.getColumnModel().getColumn(i).setModelIndex(modelIndex);
            this.monitorTable.getColumnModel().getColumn(i).setHeaderValue(this.table.getColumnName(modelIndex));
            if (Math.abs(this.curServer.sortColumn) - 1 != modelIndex) continue;
            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
            keys.add(new RowSorter.SortKey(modelIndex, this.curServer.sortColumn > 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
            this.monitorTable.getRowSorter().setSortKeys(keys);
        }
    }

    private void onClose() {
        this.packSrvColumns();
        XMLProc.saveConnections();
        this.settings.save();
        try {
            this.worker.setPause(false);
            this.worker.terminate();
            this.worker.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public MainForm() {
        this.setInitLaf();
        this.initComponents();
        this.monitorTable = new JTable();
        this.monitorTable.setModel(this.dataModel);
        this.monitorTable.setAutoResizeMode(0);
        this.monitorTable.setAutoCreateRowSorter(true);
        this.monitorTable.setSelectionMode(0);
        this.monitorTable.getTableHeader().setForeground(new Color(0, 0, 128));
        this.monitorTable.getTableHeader().setFont(new Font(this.monitorTable.getFont().getName(), 1, this.monitorTable.getFont().getSize()));
        this.monitorTable.getTableHeader().addMouseListener(new TableHeaderMouseAdapter());
        this.monitorTable.setRowSorter(new TableRowSorter<TableDataModel>(this.dataModel));
        this.monitorTable.getRowSorter().addRowSorterListener(new MonitorSorterListener());
        this.monitorTable.addKeyListener(new MainKeyListener());
        this.monitorTable.addKeyListener(new TableKeyListener());
        this.monitorTable.addMouseListener(new TableMouseAdapter());
        this.monitorTable.setComponentPopupMenu(this.tableMenu);
        this.monitorScrollPane.setViewportView(this.monitorTable);
        this.srvListModel = new SrvListModel();
        this.srvList = new SrvList();
        this.srvList.setSelectionMode(0);
        this.srvList.setModel(this.srvListModel);
        this.srvList.setCellRenderer(new SrvListCellRenderer());
        this.srvList.setComponentPopupMenu(this.srvMenu);
        this.srvList.setDragEnabled(true);
        this.srvList.setDropMode(DropMode.INSERT);
        this.srvList.setTransferHandler(new SrvListTransferHandler());
        this.srvList.setFixedCellHeight(22);
        this.srvList.getSelectionModel().addListSelectionListener(new SrvListSelectionListener());
        this.srvList.addMouseListener(new SrvListMouseAdapter());
        this.srvList.addKeyListener(new MainKeyListener());
        this.srvScrollPane.setViewportView(this.srvList);
        this.colorsPanel = new ColorsPanel();
        this.monitorPanel.add((Component)this.colorsPanel, "East");
        this.colorsPanel.setVisible(false);
        this.actSrvNew = new ActSrvNew();
        this.btnSrvNew.setAction(this.actSrvNew);
        this.btnSrvNew.getInputMap(2).put(KeyStroke.getKeyStroke(68, 128), 0);
        this.btnSrvNew.getActionMap().put(0, this.btnSrvNew.getAction());
        this.mnSrvNew.setAction(this.actSrvNew);
        this.mnSrvNew.setToolTipText(null);
        this.actSrvEdit = new ActSrvEdit();
        this.btnSrvEdit.setAction(this.actSrvEdit);
        this.btnSrvEdit.getInputMap(2).put(KeyStroke.getKeyStroke(10, 512), 0);
        this.btnSrvEdit.getActionMap().put(0, this.btnSrvEdit.getAction());
        this.mnSrvEdit.setAction(this.actSrvEdit);
        this.mnSrvEdit.setToolTipText(null);
        this.actSrvDelete = new ActSrvDelete();
        this.btnSrvDelete.setAction(this.actSrvDelete);
        this.btnSrvDelete.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), 0);
        this.btnSrvDelete.getActionMap().put(0, this.btnSrvDelete.getAction());
        this.mnSrvDelete.setAction(this.actSrvDelete);
        this.mnSrvDelete.setToolTipText(null);
        this.actSrvConnect = new ActConnect();
        this.btnConnect.setAction(this.actSrvConnect);
        this.mnConnect.setAction(this.actSrvConnect);
        this.mnConnect.setToolTipText(null);
        this.actSrvDisconnect = new ActDisconnect();
        this.btnDisconnect.setAction(this.actSrvDisconnect);
        this.mnDisconnect.setAction(this.actSrvDisconnect);
        this.mnDisconnect.setToolTipText(null);
        this.cbPeriod = new PeriodComboBox();
        this.monitorToolBar.add((Component)this.cbPeriod, 0);
        this.cbPeriod.setPreferredSize(new Dimension(120, 28));
        this.cbPeriod.addActionListener(evt -> this.worker.setPeriod(this.cbPeriod.getValue()));
        this.cbPeriod.addKeyListener(new MainKeyListener());
        this.tbRefresh.getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), 0);
        this.tbPause.getInputMap(2).put(KeyStroke.getKeyStroke(80, 0), 0);
        this.tbColors.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), 0);
        this.cbFilter.addKeyListener(new MainKeyListener());
        this.txFilter.getDocument().addDocumentListener(() -> this.applyFilter());
        this.txFilter.addKeyListener(new MainKeyListener());
        this.txConnProp.addKeyListener(new MainKeyListener());
        this.txConnString.addKeyListener(new MainKeyListener());
        this.mnFontBold.setSelected(this.settings.fbold);
        this.createThemeMenu();
        TableRenderer.renderer.setDTFormat(this.settings.dtformat);
        if (TableRenderer.renderer.getDTFormat() == 0) {
            this.mnDTFormat0.setSelected(true);
        } else {
            this.mnDTFormat1.setSelected(true);
        }
        this.tbRefresh.setIcon(JSQLMonitor.getIcon("refresh.png"));
        this.tbPause.setIcon(JSQLMonitor.getIcon("pause.png"));
        this.tbExit.setIcon(JSQLMonitor.getIcon("exit.png"));
        this.tbColors.setIcon(JSQLMonitor.getIcon("colors.png"));
        this.mnThemes.setIcon(JSQLMonitor.getIcon("themes.png"));
        this.mnFonts.setIcon(JSQLMonitor.getIcon("fonts.png"));
        this.mnHideSrvPanel.setIcon(JSQLMonitor.getIcon("hide.png"));
        this.loadSrvImages();
        this.setLaFCorrection();
        ImageIcon lcIcon = JSQLMonitor.getIcon("icon.png");
        if (lcIcon != null) {
            this.setIconImage(lcIcon.getImage());
        }
        if (this.settings.width > 200 && this.settings.height > 100) {
            this.setSize(new Dimension(this.settings.width, this.settings.height));
        }
        if ("Nimbus".equals(this.getCurrentLaFName())) {
            SwingUtilities.updateComponentTreeUI(this.srvToolBar);
        }
        this.mainSplitPane.setDividerLocation(this.srvToolBar.getPreferredSize().width + 1);
        this.setLocationByPlatform(true);
        this.worker.setPeriod(this.cbPeriod.getValue());
        this.worker.start();
    }

    private void initComponents() {
        this.srvMenu = new JPopupMenu();
        this.mnConnect = new JMenuItem();
        this.mnDisconnect = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mnSrvNew = new JMenuItem();
        this.mnSrvEdit = new JMenuItem();
        this.mnSrvDelete = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.mnHideSrvPanel = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.mnThemes = new JMenu();
        this.mnFonts = new JMenu();
        this.mnFontBold = new JCheckBoxMenuItem();
        this.tableHeaderMenu = new JPopupMenu();
        this.mnSelectColumns = new JMenuItem();
        this.mnAdjustColumns = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.mnRestColumns = new JMenuItem();
        this.tableMenu = new JPopupMenu();
        this.mnCopy = new JMenuItem();
        this.mnFilter = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.mnDTFormat = new JMenu();
        this.mnDTFormat0 = new JRadioButtonMenuItem();
        this.mnDTFormat1 = new JRadioButtonMenuItem();
        this.bgDTFormat = new ButtonGroup();
        this.mainSplitPane = new JSplitPane();
        this.srvPanel = new JPanel();
        this.srvToolBar = new JToolBar();
        this.btnConnect = new JButton();
        this.btnDisconnect = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnSrvNew = new JButton();
        this.btnSrvEdit = new JButton();
        this.btnSrvDelete = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.tbExit = new JButton();
        this.srvStatusBar = new JPanel();
        this.txSrvStatus = new JTextField();
        this.srvScrollPane = new JScrollPane();
        this.monitorPanel = new JPanel();
        this.monitorToolBar = new JToolBar();
        this.tbRefresh = new JButton();
        this.tbPause = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.tbColors = new JToggleButton();
        this.jSeparator8 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.cbFilter = new JComboBox();
        this.jLabel2 = new JLabel();
        this.txFilter = new JTextField();
        this.btnDelFilter = new JButton();
        this.monitorScrollPane = new JScrollPane();
        this.monitorStatusBar = new JPanel();
        this.txConnString = new JTextField();
        this.txRecCount = new JTextField();
        this.txConnProp = new JTextField();
        this.mnConnect.setText("jMenuItem1");
        this.srvMenu.add(this.mnConnect);
        this.mnDisconnect.setText("jMenuItem1");
        this.srvMenu.add(this.mnDisconnect);
        this.srvMenu.add(this.jSeparator2);
        this.mnSrvNew.setText("jMenuItem1");
        this.srvMenu.add(this.mnSrvNew);
        this.mnSrvEdit.setText("jMenuItem1");
        this.srvMenu.add(this.mnSrvEdit);
        this.mnSrvDelete.setText("jMenuItem1");
        this.srvMenu.add(this.mnSrvDelete);
        this.srvMenu.add(this.jSeparator5);
        this.mnHideSrvPanel.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mnHideSrvPanel.setText("Hide/Show panel");
        this.mnHideSrvPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnHideSrvPanelActionPerformed(evt);
            }
        });
        this.srvMenu.add(this.mnHideSrvPanel);
        this.srvMenu.add(this.jSeparator7);
        this.mnThemes.setText("UI Theme");
        this.srvMenu.add(this.mnThemes);
        this.mnFonts.setText("UI Fonts");
        this.mnFontBold.setText("UI Fonts Bold");
        this.mnFontBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnFontBoldActionPerformed(evt);
            }
        });
        this.mnFonts.add(this.mnFontBold);
        this.srvMenu.add(this.mnFonts);
        this.mnSelectColumns.setText("Select columns");
        this.mnSelectColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnSelectColumnsActionPerformed(evt);
            }
        });
        this.tableHeaderMenu.add(this.mnSelectColumns);
        this.mnAdjustColumns.setText("Adjust columns width");
        this.mnAdjustColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnAdjustColumnsActionPerformed(evt);
            }
        });
        this.tableHeaderMenu.add(this.mnAdjustColumns);
        this.tableHeaderMenu.add(this.jSeparator4);
        this.mnRestColumns.setText("Reset columns settings");
        this.mnRestColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnRestColumnsActionPerformed(evt);
            }
        });
        this.tableHeaderMenu.add(this.mnRestColumns);
        this.mnCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.mnCopy.setText("Copy value");
        this.mnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnCopyActionPerformed(evt);
            }
        });
        this.tableMenu.add(this.mnCopy);
        this.mnFilter.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.mnFilter.setText("Filter by value");
        this.mnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnFilterActionPerformed(evt);
            }
        });
        this.tableMenu.add(this.mnFilter);
        this.tableMenu.add(this.jSeparator9);
        this.mnDTFormat.setText("Timestamp format");
        this.bgDTFormat.add(this.mnDTFormat0);
        this.mnDTFormat0.setText("default");
        this.mnDTFormat0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnDTFormat0ActionPerformed(evt);
            }
        });
        this.mnDTFormat.add(this.mnDTFormat0);
        this.bgDTFormat.add(this.mnDTFormat1);
        this.mnDTFormat1.setText("dd.MM.yyyy HH:mm:ss");
        this.mnDTFormat1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.mnDTFormat1ActionPerformed(evt);
            }
        });
        this.mnDTFormat.add(this.mnDTFormat1);
        this.tableMenu.add(this.mnDTFormat);
        this.setDefaultCloseOperation(3);
        this.setTitle("jSQLMonitor");
        this.setSize(new Dimension(0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainForm.this.formWindowClosing(evt);
            }
        });
        this.mainSplitPane.setDividerSize(6);
        this.srvPanel.setLayout(new BorderLayout());
        this.srvToolBar.setFloatable(false);
        this.btnConnect.setFocusable(false);
        this.btnConnect.setHideActionText(true);
        this.btnConnect.setHorizontalTextPosition(0);
        this.srvToolBar.add(this.btnConnect);
        this.btnDisconnect.setFocusable(false);
        this.btnDisconnect.setHideActionText(true);
        this.btnDisconnect.setHorizontalTextPosition(0);
        this.srvToolBar.add(this.btnDisconnect);
        this.srvToolBar.add(this.jSeparator1);
        this.btnSrvNew.setFocusable(false);
        this.btnSrvNew.setHideActionText(true);
        this.btnSrvNew.setHorizontalTextPosition(0);
        this.srvToolBar.add(this.btnSrvNew);
        this.btnSrvEdit.setFocusable(false);
        this.btnSrvEdit.setHideActionText(true);
        this.btnSrvEdit.setHorizontalTextPosition(0);
        this.srvToolBar.add(this.btnSrvEdit);
        this.btnSrvDelete.setFocusable(false);
        this.btnSrvDelete.setHideActionText(true);
        this.btnSrvDelete.setHorizontalTextPosition(0);
        this.srvToolBar.add(this.btnSrvDelete);
        this.srvToolBar.add(this.jSeparator6);
        this.tbExit.setToolTipText("Exit");
        this.tbExit.setFocusable(false);
        this.tbExit.setHorizontalTextPosition(0);
        this.tbExit.setVerticalTextPosition(3);
        this.tbExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.tbExitActionPerformed(evt);
            }
        });
        this.srvToolBar.add(this.tbExit);
        this.srvPanel.add((Component)this.srvToolBar, "First");
        this.srvStatusBar.setBorder(BorderFactory.createEmptyBorder(1, 2, 2, 2));
        this.txSrvStatus.setEditable(false);
        this.txSrvStatus.setBorder(new SoftBevelBorder(1));
        this.txSrvStatus.setFocusable(false);
        GroupLayout srvStatusBarLayout = new GroupLayout(this.srvStatusBar);
        this.srvStatusBar.setLayout(srvStatusBarLayout);
        srvStatusBarLayout.setHorizontalGroup(srvStatusBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txSrvStatus));
        srvStatusBarLayout.setVerticalGroup(srvStatusBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txSrvStatus, GroupLayout.Alignment.TRAILING));
        this.srvPanel.add((Component)this.srvStatusBar, "Last");
        this.srvPanel.add((Component)this.srvScrollPane, "Center");
        this.mainSplitPane.setLeftComponent(this.srvPanel);
        this.monitorPanel.setLayout(new BorderLayout());
        this.monitorToolBar.setFloatable(false);
        this.tbRefresh.setToolTipText("Refresh");
        this.tbRefresh.setFocusable(false);
        this.tbRefresh.setHorizontalTextPosition(0);
        this.tbRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.tbRefreshActionPerformed(evt);
            }
        });
        this.monitorToolBar.add(this.tbRefresh);
        this.tbPause.setToolTipText("Pause");
        this.tbPause.setFocusable(false);
        this.tbPause.setHorizontalTextPosition(0);
        this.tbPause.setVerticalTextPosition(3);
        this.tbPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.tbPauseActionPerformed(evt);
            }
        });
        this.monitorToolBar.add(this.tbPause);
        this.jSeparator3.setSeparatorSize(new Dimension(20, 10));
        this.monitorToolBar.add(this.jSeparator3);
        this.tbColors.setToolTipText("Show color statistics");
        this.tbColors.setFocusable(false);
        this.tbColors.setHorizontalTextPosition(0);
        this.tbColors.setVerticalTextPosition(3);
        this.tbColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.tbColorsActionPerformed(evt);
            }
        });
        this.monitorToolBar.add(this.tbColors);
        this.jSeparator8.setSeparatorSize(new Dimension(20, 10));
        this.monitorToolBar.add(this.jSeparator8);
        this.jLabel1.setText("Filter ");
        this.monitorToolBar.add(this.jLabel1);
        this.cbFilter.setMaximumRowCount(40);
        this.cbFilter.setPreferredSize(new Dimension(200, 28));
        this.cbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.cbFilterActionPerformed(evt);
            }
        });
        this.monitorToolBar.add(this.cbFilter);
        this.jLabel2.setText(" RegExp ");
        this.monitorToolBar.add(this.jLabel2);
        this.txFilter.setPreferredSize(new Dimension(100, 23));
        this.txFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainForm.this.txFilterMouseClicked(evt);
            }
        });
        this.monitorToolBar.add(this.txFilter);
        this.btnDelFilter.setText("X");
        this.btnDelFilter.setFocusable(false);
        this.btnDelFilter.setHorizontalTextPosition(0);
        this.btnDelFilter.setVerticalTextPosition(3);
        this.btnDelFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.btnDelFilterActionPerformed(evt);
            }
        });
        this.monitorToolBar.add(this.btnDelFilter);
        this.monitorPanel.add((Component)this.monitorToolBar, "First");
        this.monitorPanel.add((Component)this.monitorScrollPane, "Center");
        this.monitorStatusBar.setBorder(BorderFactory.createEmptyBorder(1, 2, 2, 2));
        this.txConnString.setEditable(false);
        this.txConnString.setToolTipText("Connection string");
        this.txConnString.setBorder(new SoftBevelBorder(1));
        this.txRecCount.setEditable(false);
        this.txRecCount.setForeground(Color.blue);
        this.txRecCount.setHorizontalAlignment(0);
        this.txRecCount.setToolTipText("Record count");
        this.txRecCount.setBorder(new SoftBevelBorder(1));
        this.txRecCount.setFocusable(false);
        this.txConnProp.setEditable(false);
        this.txConnProp.setForeground(new Color(0, 102, 0));
        this.txConnProp.setToolTipText("Connection info: user@catalog.schema");
        this.txConnProp.setBorder(new SoftBevelBorder(1));
        GroupLayout monitorStatusBarLayout = new GroupLayout(this.monitorStatusBar);
        this.monitorStatusBar.setLayout(monitorStatusBarLayout);
        monitorStatusBarLayout.setHorizontalGroup(monitorStatusBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(monitorStatusBarLayout.createSequentialGroup().addComponent(this.txRecCount, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txConnProp, -2, 400, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txConnString)));
        monitorStatusBarLayout.setVerticalGroup(monitorStatusBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txRecCount, -1, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, monitorStatusBarLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txConnString, -1, -1, -2).addComponent(this.txConnProp, -2, -1, -2)));
        this.monitorPanel.add((Component)this.monitorStatusBar, "Last");
        this.mainSplitPane.setRightComponent(this.monitorPanel);
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.setBounds(0, 0, 1016, 639);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.onClose();
    }

    private void tbRefreshActionPerformed(ActionEvent evt) {
        this.worker.forceUpdate();
    }

    private void mnAdjustColumnsActionPerformed(ActionEvent evt) {
        this.adjustColumnsWidth();
    }

    private void mnSelectColumnsActionPerformed(ActionEvent evt) {
        int monitorHeight = MouseInfo.getPointerInfo().getDevice().getDisplayMode().getHeight();
        int taskbarHeight = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)MouseInfo.getPointerInfo().getDevice().getDefaultConfiguration()).bottom;
        int mousePos = MouseInfo.getPointerInfo().getLocation().y;
        ColumnsForm columnsForm = new ColumnsForm();
        columnsForm.setLocation(MouseInfo.getPointerInfo().getLocation());
        columnsForm.setSize(new Dimension(columnsForm.getPreferredSize().width, Math.min(columnsForm.getPreferredSize().height, monitorHeight - mousePos - taskbarHeight)));
        columnsForm.setVisible(true);
    }

    private void tbPauseActionPerformed(ActionEvent evt) {
        this.worker.setPause(this.tbPause.isSelected());
    }

    private void mnRestColumnsActionPerformed(ActionEvent evt) {
        this.curServer.sortColumn = 0;
        this.resetColumns();
    }

    private void cbFilterActionPerformed(ActionEvent evt) {
        if (this.flFilterListUpdating) {
            return;
        }
        this.txFilter.selectAll();
        this.txFilter.requestFocus();
        this.applyFilter();
    }

    private void btnDelFilterActionPerformed(ActionEvent evt) {
        this.txFilter.setText("");
        this.applyFilter();
    }

    private void txFilterMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) & evt.getClickCount() > 1) {
            this.txFilter.setText("");
            this.applyFilter();
        }
    }

    private void tbExitActionPerformed(ActionEvent evt) {
        this.onClose();
        this.dispose();
    }

    private void mnFontBoldActionPerformed(ActionEvent evt) {
        boolean fl = ((JCheckBoxMenuItem)evt.getSource()).isSelected();
        UIManager.put("swing.boldMetal", fl);
        if (!this.setLaF(this.curLaFIdx)) {
            ((JCheckBoxMenuItem)evt.getSource()).setSelected(!fl);
        }
    }

    private void mnHideSrvPanelActionPerformed(ActionEvent evt) {
        this.hideSrvPanel();
    }

    private void tbColorsActionPerformed(ActionEvent evt) {
        this.colorsPanel.setVisible(this.tbColors.isSelected());
        this.updateColorsStat();
    }

    private void mnCopyActionPerformed(ActionEvent evt) {
        this.copyCell();
    }

    private void mnFilterActionPerformed(ActionEvent evt) {
        this.setFilterByCell();
    }

    private void mnDTFormat0ActionPerformed(ActionEvent evt) {
        TableRenderer.renderer.setDTFormat(0);
        this.monitorTable.repaint();
    }

    private void mnDTFormat1ActionPerformed(ActionEvent evt) {
        TableRenderer.renderer.setDTFormat(1);
        this.monitorTable.repaint();
    }

    private class AuxRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        int idx;

        AuxRadioButtonMenuItem(String text) {
            super(text);
        }
    }

    private class TableHeaderMouseAdapter
    extends MouseAdapter {
        private TableHeaderMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            if (SwingUtilities.isRightMouseButton(evt) & MainForm.this.canManageColumns()) {
                MainForm.this.tableHeaderMenu.show(header, evt.getX(), evt.getY());
            }
        }
    }

    private class MonitorSorterListener
    implements RowSorterListener {
        private MonitorSorterListener() {
        }

        @Override
        public void sorterChanged(RowSorterEvent evt) {
            if (((RowSorter)evt.getSource()).getSortKeys().size() != 0) {
                ((MainForm)MainForm.this).curServer.sortColumn = (((RowSorter)evt.getSource()).getSortKeys().get(0).getColumn() + 1) * (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder() == SortOrder.ASCENDING ? 1 : -1);
            }
        }
    }

    private class MainKeyListener
    implements KeyListener {
        private MainKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 116) {
                MainForm.this.tbRefresh.doClick();
            }
            if (evt.getKeyCode() == 80) {
                MainForm.this.tbPause.doClick();
            }
            if (evt.getKeyCode() == 114) {
                MainForm.this.tbColors.doClick();
            }
            if (evt.getKeyCode() == 113) {
                MainForm.this.hideSrvPanel();
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }
    }

    private class TableKeyListener
    implements KeyListener {
        private TableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 67 && (evt.getModifiersEx() & 0x280) == 128) {
                MainForm.this.copyCell();
                evt.consume();
            }
            if (evt.getKeyCode() == 88 && (evt.getModifiersEx() & 0x80) == 128) {
                MainForm.this.setFilterByCell();
                evt.consume();
            }
            if (evt.getKeyCode() == 10) {
                MainForm.this.showViewCell();
                evt.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }
    }

    private class TableMouseAdapter
    extends MouseAdapter {
        private TableMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (SwingUtilities.isRightMouseButton(evt)) {
                JTable lcTable = (JTable)evt.getSource();
                lcTable.changeSelection(lcTable.rowAtPoint(evt.getPoint()), lcTable.columnAtPoint(evt.getPoint()), false, false);
            }
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
                MainForm.this.showViewCell();
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (SwingUtilities.isRightMouseButton(evt)) {
                JTable lcTable = (JTable)evt.getSource();
                lcTable.changeSelection(lcTable.rowAtPoint(evt.getPoint()), lcTable.columnAtPoint(evt.getPoint()), false, false);
            }
        }
    }

    private class SrvListCellRenderer
    extends DefaultListCellRenderer {
        private SrvListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aSrvList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Server server = (Server)value;
            this.setText(server.name);
            if (isSelected) {
                this.setBackground(aSrvList.getSelectionBackground());
                this.setForeground(aSrvList.getSelectionForeground());
            } else {
                this.setBackground(aSrvList.getBackground());
                this.setForeground(aSrvList.getForeground());
            }
            this.setIcon(MainForm.this.srvIcons[server.state.ordinal()]);
            return this;
        }
    }

    private class SrvListTransferHandler
    extends TransferHandler {
        private int Idx1;
        private int Idx2;

        private SrvListTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent aComp) {
            return 0x40000000;
        }

        @Override
        public Transferable createTransferable(JComponent aComp) {
            this.Idx1 = MainForm.this.srvList.getSelectedIndex();
            return new ServerTransferable((Server)MainForm.this.srvList.getSelectedValue());
        }

        @Override
        public void exportDone(JComponent aComp, Transferable aServerTransferable, int aAction) {
            if (aAction == 0x40000000) {
                try {
                    MainForm.this.srvListModel.removeElementAt(this.Idx2);
                    MainForm.this.srvList.setSelectedIndex(this.Idx1);
                    XMLProc.saveConnections();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport aSupport) {
            return aSupport.isDataFlavorSupported(ServerTransferable.SERVER_FLAVOR);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport aSupport) {
            try {
                Server server = (Server)aSupport.getTransferable().getTransferData(ServerTransferable.SERVER_FLAVOR);
                int lcIdx = ((JList.DropLocation)aSupport.getDropLocation()).getIndex();
                MainForm.this.srvListModel.add(lcIdx, server);
                this.Idx2 = this.Idx1 < lcIdx ? this.Idx1 : this.Idx1 + 1;
                this.Idx1 = this.Idx2 < lcIdx ? lcIdx - 1 : lcIdx;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private class SrvListSelectionListener
    implements ListSelectionListener {
        private SrvListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            MainForm.this.tuneActions();
            MainForm.this.monitoring(MainForm.this.getCurrentServer());
        }
    }

    private class SrvListMouseAdapter
    extends MouseAdapter {
        private SrvListMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (SwingUtilities.isRightMouseButton(evt)) {
                MainForm.this.srvList.setSelectedIndex(MainForm.this.srvList.locationToIndex(evt.getPoint()));
            }
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
                MainForm.this.actSrvConnect.actionPerformed(new ActionEvent(evt, 0, ""));
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (SwingUtilities.isRightMouseButton(evt)) {
                MainForm.this.srvList.setSelectedIndex(MainForm.this.srvList.locationToIndex(evt.getPoint()));
            }
        }
    }
}

