/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.awt.Cursor;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Properties;
import ru.ovs.jsqlmonitor.Driver;
import ru.ovs.jsqlmonitor.LoginParam;
import ru.ovs.jsqlmonitor.ServerState;
import ru.ovs.jsqlmonitor.Utils;

public class Server {
    String drvName;
    String name;
    String user;
    String connString;
    String sqlScript;
    char[] password;
    boolean kerberos;
    boolean readOnly;
    Driver driver;
    ServerState state;
    final ArrayList<ArrayList<Integer>> columns;
    int sortColumn;
    int fltCol;
    String fltText;
    private Connection connection;
    private PreparedStatement statement;
    private String curUser;

    boolean passwSaved() {
        return this.password != null;
    }

    boolean connected() {
        return this.state == ServerState.Connected;
    }

    String columnsToString() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            new ObjectOutputStream(stream).writeObject(this.columns);
            return Base64.getEncoder().encodeToString(stream.toByteArray());
        }
        catch (Exception exc) {
            return "";
        }
    }

    void stringToColumns(String base64) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(Base64.getDecoder().decode(base64));
            this.columns.addAll((ArrayList)new ObjectInputStream(stream).readObject());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void prepare() {
        if (this.connect()) {
            try {
                this.statement = this.connection.prepareStatement(Utils.getStringFromFile(this.sqlScript));
            }
            catch (Exception exc) {
                Utils.ShowError("Unable to load query text.\nError: " + exc.getMessage());
                this.disconnect();
                this.state = ServerState.Error;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean connect() {
        if (this.state == ServerState.Connected) {
            return true;
        }
        Properties prop = new Properties();
        prop.put("ApplicationName", "jSQLMonitor");
        if (this.kerberos) {
            prop.put("integratedSecurity", "true");
            this.curUser = System.getProperty("user.name");
        } else {
            LoginParam loginParam = new LoginParam(this.user, this.password);
            if (!this.passwSaved() && !Utils.getLoginParam(loginParam)) {
                return false;
            }
            prop.put("user", loginParam.getUser());
            prop.put("password", loginParam.getStrPassword());
            loginParam.setPassword(null);
            this.curUser = loginParam.getUser();
        }
        Window window = Utils.getActiveWindow();
        window.setCursor(new Cursor(3));
        try {
            this.connection = this.driver.getSQLDriver().connect(this.connString, prop);
            if (this.connection == null) {
                throw new Exception("Invalid connection string.");
            }
            this.state = ServerState.Connected;
            if (this.readOnly) {
                this.setReadOnly();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exc) {
            this.state = ServerState.Error;
            Utils.ShowError("An error occurred while connecting to " + this.name + ".\nException: " + exc.getClass().getTypeName() + "\nMessage: " + exc.getMessage());
        }
        catch (Error exc) {
            this.state = ServerState.Error;
            Utils.ShowError("Virtual Machine Error: " + exc.getClass().getTypeName() + "\nMessage: " + exc.getMessage());
        }
        finally {
            window.setCursor(null);
        }
        return false;
    }

    void disconnect() {
        if (this.state != ServerState.Connected) {
            return;
        }
        try {
            this.connection.close();
            this.state = ServerState.Disconnected;
        }
        catch (SQLException exc) {
            this.state = ServerState.Error;
            Utils.ShowError("Unable to close connection.\nError: " + exc.getMessage());
        }
        this.connection = null;
    }

    private void setReadOnly() {
        try {
            this.connection.setReadOnly(true);
        }
        catch (SQLException exc) {
            Utils.ShowWarning("Unable to set read-only connection.\nError: " + exc.getMessage());
        }
    }

    PreparedStatement getStatement() {
        return this.statement;
    }

    String getConnectionInfo() {
        String result = "";
        try {
            if (this.connection != null) {
                String catalog = this.connection.getCatalog();
                String schema = this.connection.getSchema();
                if ("".equals(catalog)) {
                    catalog = "<empty>";
                }
                if ("".equals(schema)) {
                    schema = "<empty>";
                }
                result = this.curUser + "@" + catalog + '.' + schema;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    Server(String aDrvName, String aName, String aUser, char[] aPassword, boolean aKerberos, String aConnString, boolean aReadOnly, String aSqlScript) {
        this.drvName = Utils.noNull(aDrvName);
        this.name = Utils.noNull(aName);
        this.user = Utils.noNull(aUser);
        this.connString = Utils.noNull(aConnString);
        this.password = aPassword;
        this.kerberos = aKerberos;
        this.readOnly = aReadOnly;
        this.sqlScript = Utils.noNull(aSqlScript);
        this.driver = Utils.findDrv(this.drvName);
        this.state = this.driver == null ? ServerState.NoDriver : (Utils.isBlank(this.driver.drvClass) ? ServerState.NoDriver : ServerState.Disconnected);
        this.columns = new ArrayList();
        this.sortColumn = 0;
        this.fltCol = 0;
        this.fltText = "";
    }
}

