/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.util.ArrayList;

public class Table {
    private final ArrayList<Field> header = new ArrayList();
    private final ArrayList<Row> data = new ArrayList();

    private Field getColumn(int Column) {
        return this.header.get(Column);
    }

    void updateTable(Table source, boolean updateHeader) {
        int i;
        if (updateHeader) {
            this.header.clear();
            for (i = 0; i < source.getColumnCount(); ++i) {
                this.header.add(source.getColumn(i));
            }
            this.data.clear();
        } else {
            for (i = this.getRowCount(); i > source.getRowCount(); --i) {
                this.data.remove(i - 1);
            }
        }
        for (i = 0; i < source.getRowCount(); ++i) {
            int j;
            Row row;
            if (this.getRowCount() - 1 < i) {
                row = new Row();
                this.data.add(row);
                for (j = 0; j < source.getColumnCount(); ++j) {
                    row.add(source.getVal(i, j));
                }
            } else {
                row = this.data.get(i);
                for (j = 0; j < source.getColumnCount(); ++j) {
                    row.set(j, source.getVal(i, j));
                }
            }
            row.color = source.getColor(i);
        }
    }

    public boolean headerIsEmpty() {
        return this.header.isEmpty();
    }

    public void clearHeader() {
        this.header.clear();
    }

    public void clearData() {
        this.data.clear();
    }

    public void clearAll() {
        this.header.clear();
        this.data.clear();
    }

    public void addColumn(String aName, String aClassName) {
        Class<Object> lcClass;
        try {
            lcClass = Class.forName(aClassName);
        }
        catch (ClassNotFoundException exc) {
            lcClass = Object.class;
        }
        this.header.add(new Field(aName, lcClass));
    }

    public void addRow(Row aRow) {
        this.data.add(aRow);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.header.size();
    }

    public String getColumnName(int Column) {
        return this.header.get(Column).name;
    }

    public Class getColumnType(int Column) {
        return this.header.get(Column).type;
    }

    public Object getVal(int rec, int col) {
        return this.data.get(rec).get(col);
    }

    public ArrayList<Field> getHeader() {
        return this.header;
    }

    public Integer getColor(int rec) {
        return this.data.get((int)rec).color;
    }

    private class Field {
        private String name;
        private Class type;

        private Field(String aName, Class aType) {
            this.name = aName;
            this.type = aType;
        }
    }

    public static class Row
    extends ArrayList<Object> {
        Integer color;
    }
}

