/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import ru.ovs.jsqlmonitor.TableDataModel;

class TableRenderer
extends DefaultTableCellRenderer {
    static TableRenderer renderer = new TableRenderer();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private final Border border1 = BorderFactory.createMatteBorder(2, 0, 2, 0, Color.BLUE);
    private final Border border2 = BorderFactory.createMatteBorder(2, 1, 2, 1, Color.BLUE);
    private int dtFormat = 0;

    TableRenderer() {
    }

    void setDTFormat(int AdtFormat) {
        this.dtFormat = AdtFormat;
        if (this.dtFormat < 0 | this.dtFormat > 1) {
            this.dtFormat = 0;
        }
    }

    int getDTFormat() {
        return this.dtFormat;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color lcColor;
        JLabel lb = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Integer lcIntColor = ((TableDataModel)table.getModel()).getColor(table.convertRowIndexToModel(row));
        Color color = lcColor = lcIntColor == null ? table.getBackground() : new Color(lcIntColor);
        if (isSelected) {
            if (column == table.getSelectedColumn()) {
                lb.setBorder(this.border2);
            } else {
                lb.setBorder(this.border1);
            }
        }
        if (isSelected && column == table.getSelectedColumn()) {
            lb.setForeground(lcColor.brighter().brighter());
            lb.setBackground(lcColor.darker().darker());
        } else {
            lb.setForeground(table.getForeground());
            lb.setBackground(lcColor);
        }
        if (value instanceof Timestamp && this.dtFormat != 0 && value != null) {
            lb.setText(((Timestamp)value).toLocalDateTime().format(this.formatter));
        }
        if (value instanceof BigDecimal || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            lb.setHorizontalAlignment(4);
        } else if (value instanceof Boolean || value instanceof Timestamp || value instanceof Date || value instanceof Time) {
            lb.setHorizontalAlignment(0);
        } else {
            lb.setHorizontalAlignment(2);
        }
        return lb;
    }
}

