/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.awt.Window;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.swing.FocusManager;
import javax.swing.JOptionPane;
import ru.ovs.jsqlmonitor.Driver;
import ru.ovs.jsqlmonitor.JSQLMonitor;
import ru.ovs.jsqlmonitor.LoginForm;
import ru.ovs.jsqlmonitor.LoginParam;
import ru.ovs.jsqlmonitor.ModalResult;

class Utils {
    Utils() {
    }

    static boolean drvExists(String aDrvName) {
        for (Driver lcDrv : JSQLMonitor.drvList) {
            if (!lcDrv.drvName.equals(aDrvName)) continue;
            return true;
        }
        return false;
    }

    static Driver findDrv(String aDrvName) {
        for (Driver lcDrv : JSQLMonitor.drvList) {
            if (!lcDrv.drvName.equals(aDrvName)) continue;
            return lcDrv;
        }
        return null;
    }

    static String noNull(String aStr) {
        return aStr == null ? "" : aStr;
    }

    static boolean isBlank(String aStr) {
        return Utils.noNull(aStr).trim().length() == 0;
    }

    static void wipeCharArray(char[] aCharArray) {
        if (aCharArray != null) {
            Arrays.fill(aCharArray, '\u0000');
        }
    }

    static boolean getLoginParam(LoginParam aLoginParam) {
        LoginForm loginForm = new LoginForm(aLoginParam);
        loginForm.setLocationRelativeTo(JSQLMonitor.mainForm);
        loginForm.setVisible(true);
        return loginForm.modalResult == ModalResult.OK;
    }

    static Window getActiveWindow() {
        Window window = FocusManager.getCurrentManager().getActiveWindow();
        if (window instanceof LoginForm) {
            window = window.getOwner();
        }
        return window == null ? JSQLMonitor.mainForm : window;
    }

    static String getStringFromFile(String filePath) throws IOException {
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0]).toAbsolutePath()), StandardCharsets.UTF_8);
    }

    static void ShowError(String message) {
        JOptionPane.showMessageDialog(Utils.getActiveWindow(), message, "Error", 0);
    }

    static void ShowWarning(String message) {
        JOptionPane.showMessageDialog(Utils.getActiveWindow(), message, "Warning", 2);
    }

    static void ShowMessage(String message) {
        JOptionPane.showMessageDialog(Utils.getActiveWindow(), message, "Information", 1);
    }
}

