/*
 * Decompiled with CFR 0.152.
 */
package ru.ovs.jsqlmonitor;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import javax.swing.SwingUtilities;
import ru.ovs.jsqlmonitor.JSQLMonitor;
import ru.ovs.jsqlmonitor.Server;
import ru.ovs.jsqlmonitor.Table;

public class Worker
extends Thread {
    private boolean terminated;
    private PreparedStatement statement;
    private PreparedStatement NewStatement;
    private int period;
    private Table buffer;
    private boolean needUpdate;
    private boolean flReconnect;
    private boolean flError;
    private Server currentServer;
    private boolean pause;
    boolean waiting;
    public final Object sync = new Object();
    public final Object syncPause = new Object();

    Worker() {
        this.buffer = new Table();
    }

    private void delay() {
        try {
            Worker.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (!this.terminated) {
            if (this.pause) {
                this.waiting = true;
                Object object = this.syncPause;
                synchronized (object) {
                    try {
                        this.syncPause.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.waiting = false;
            this.getData();
            this.needUpdate = false;
            long curTime = System.currentTimeMillis();
            while (!(this.terminated || this.needUpdate || this.pause)) {
                this.delay();
                if (System.currentTimeMillis() - curTime < (long)this.period) continue;
                continue block5;
            }
        }
    }

    public Table getBuffer() {
        return this.buffer;
    }

    public void terminate() {
        this.terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdate() {
        this.needUpdate = true;
        if (this.pause) {
            Object object = this.syncPause;
            synchronized (object) {
                this.syncPause.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPause(boolean Apause) {
        this.pause = Apause;
        if (!this.pause) {
            Object object = this.syncPause;
            synchronized (object) {
                this.syncPause.notify();
            }
        }
    }

    void setStatement(PreparedStatement aStatement, Server aServer) {
        this.NewStatement = aStatement;
        this.currentServer = aServer;
        this.flError = false;
    }

    void setPeriod(int aPeriod) {
        this.period = aPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getData() {
        boolean bl = this.flReconnect = this.statement != this.NewStatement;
        if (this.flReconnect) {
            this.flError = false;
        }
        if (this.flError) {
            return;
        }
        this.statement = this.NewStatement;
        if (this.statement == null & this.flReconnect) {
            Object object = this.sync;
            synchronized (object) {
                this.buffer.clearAll();
            }
            SwingUtilities.invokeLater(() -> JSQLMonitor.mainForm.updateMonitor(true, false, this.currentServer));
        } else if (this.statement != null) {
            try {
                if (!this.statement.execute()) {
                    throw new Exception("No data set was received from the server.");
                }
                ResultSet rs = this.statement.getResultSet();
                ResultSetMetaData md = rs.getMetaData();
                Object object = this.sync;
                synchronized (object) {
                    if (this.flReconnect) {
                        this.buffer.clearHeader();
                        for (int i = 1; i <= md.getColumnCount(); ++i) {
                            if ("Color".equalsIgnoreCase(md.getColumnName(i))) continue;
                            this.buffer.addColumn(md.getColumnName(i), md.getColumnClassName(i));
                        }
                    }
                    this.buffer.clearData();
                    while (rs.next()) {
                        Table.Row row = new Table.Row();
                        for (int i = 1; i <= md.getColumnCount(); ++i) {
                            if ("Color".equalsIgnoreCase(md.getColumnName(i))) {
                                try {
                                    row.color = (Integer)rs.getObject(i);
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            row.add(rs.getObject(i));
                        }
                        this.buffer.addRow(row);
                    }
                }
                SwingUtilities.invokeLater(() -> JSQLMonitor.mainForm.updateMonitor(this.flReconnect, false, this.currentServer));
            }
            catch (Exception exc) {
                this.flError = true;
                Object object = this.sync;
                synchronized (object) {
                    this.buffer.clearAll();
                    this.buffer.addColumn("ERROR", "String");
                    Table.Row row = new Table.Row();
                    row.add(exc.getMessage());
                    this.buffer.addRow(row);
                }
                SwingUtilities.invokeLater(() -> JSQLMonitor.mainForm.updateMonitor(true, true, this.currentServer));
            }
        }
    }
}

